define(["angular", "app"], function (angular, app) {
	"use strict";

	app.controller("SupportSummaryController", function ($scope, $filter, $state, $stateParams, SupportConstants) {
		
		$scope.featureName = $state.current.data.appletName;
		$scope.sectionTitle = $filter("filter")($state.current.data.paramSections, { paramValue: $stateParams.section }, true)[0].sectionName;
		$scope.sectionTemplate = 'src/modules/support/pages/summary/partials/'+ $stateParams.section +'_template.html';
		$scope.currentSection = $stateParams.section;

		if ($scope.currentSection === "mindfulness") {
			angular.extend($scope, SupportConstants[$stateParams.section].scope);
		}
		
		$scope.openMvahLink = function () {
			if (window.cordova) {
				window.open("mhpmyvahealth://");
			} else {
				window.open("../../../my-va-health/#/home", "_blank");
			}
		};

		$scope.openMendedHearts = function () {
			window.open("https://www.inspire.com/groups/mended-hearts-heart-disease/", "_blank");
		};

	});
});